﻿/*		VERSION:		1.6
1.6		FIX: 		tell() was disabling all previous then() reactions
1.5		"unload" events always fire only once
			react.unload() always fires all "unload" events that were created using react
1.4		changed	tell()  to allow re-tranmitting an event using a different event name			react.to("click").tell(mc, "omgEvent")
1.3		added once()
1.2		added tell()

USAGE:
	_this = this;
	#include "functions/eventSystem3.as"
	if(!_this.addListener)		AsBroadcaster.initialize( _this );
	if(!react)								var react = make_react( _this );		// param is optional
	function onUnload(){
		sendEvent( "unload" );		// this will trigger react.unload()		... and trigger any external code listening for "unload" to occur here
	}// onUnload()
	
	
	react.to("click").from(mc).then = function(evt){}
	
	
	react.to("testEvent").tell(button1).then = 
	react.to("click").from(button1).tell(button2).then = 
	
	
	react.once().to("testEvent").then = 
	react.to("testEvent").once().then = 
	react.to("testEvent").from(button1).once().then = 
	
	
	var detectClick = react.to("click").from(_this);
	detectClick.then = function(evt){}
	detectClick.disable();
*/
#include "sendEvent.as"
function make_react( defaultUnloadEmitter )
{
	var react = {};		// interface
	var reactOnce = {};
	var eventEmitters = [];
	
	
	
	//////////////////////////////////////////
	react.to = function( eventName, fireOnce ){
		var event = {};
		var tellEventTarget = null;
		var tellEventName = eventName;
		var fireOnce = fireOnce || false;
		if( eventName === "unload" )		fireOnce = true;
		
		// when from() is NOT used
		if( defaultUnloadEmitter ){
			var emitter = defaultUnloadEmitter;
			var _interface = event;
			_interface.fire;		//  can manually fire this event
			
			// catch actual event => eventTarget obj
			var eventTarget = {};		// the actual events fire at this
			if(emitter.addEventListener){
				emitter.addEventListener( eventName, eventTarget );
			}else if(emitter.addListener){
				emitter.addListener( eventTarget );
			}else{
				// cannot create event,  so return nothing
				var nam = (emitter._name === undefined) ? "[object]" : '"'+emitter._name+'"';
				trace('ERROR:  '+nam+' cannot send events. ('+eventName+')');
				return null;
			}
			
			// event occurs => then()
			_interface.fire = eventTarget[eventName] = function(){
				_interface.then.apply( null, arguments.slice() );		// when this event occurs,  run then()  and pass-thru all provided parameters to it
				// tell()
				var params = [eventName].concat( arguments.slice() );
				sendEventToTarget.apply( null, params );		// when this event occurs,  pass the event to the tellEventTarget
				// once
				if(fireOnce)		_interface.disable();
			}// upon event()
			
			// remember this event
			var eventDetails = {
				emitter: emitter,
				eventName: eventName,
				eventTarget: eventTarget, 
				fire:  function() {
					return _interface.fire();
				}
			}
			eventEmitters.push(eventDetails);
			
			// manually destroy event
			_interface.disable = function(){
				delete _interface.fire;
				disableEvent( emitter, eventName, eventTarget );
				forgetEvent( emitter, eventName, eventTarget );
			}// disable()
		}// if:  default emitter was specified
		
		
		// when tell() is specified
		event.tell = function( newTarget, newEventName ){
			// react.to("click").tell( this, {about:"tellEvent"} )
			if( newEventName instanceof Object ){
				newEventName = newEventName.about  ||  newEventName.to;
			}
			tellEventTarget = newTarget;
			tellEventName = newEventName || tellEventName;
			return this;		// make this a chain-able monad
		}// tell()
		
		
		// once
		event.once = function(){
			fireOnce = true;
			return this;		// make this a chain-able monad
		}
		
		
		function sendEventToTarget(eventName, evt){
			if(!tellEventTarget)		return;
			if(!tellEventName)			return;
			
			// carry-over the same evt data,  but change "type" to be the new event-name
			var tell_evt = {}
			for(var nam in evt)		tell_evt[ nam ] = evt[ nam ];
			tell_evt.type = tellEventName;
			
			//var sendEventName = tellEventName || eventName;
			sendEvent( tellEventName, tell_evt, tellEventTarget);
		}// sendEventToTarget()
		
		
		
		//////////////////////////////////////////
		// when from() is specified
		event.from = function( emitter ){
			event.disable();		// replace react.to().then events
			
			var _interface = {};
			_interface.fire;		//  can manually fire this event
			
			// catch actual event => eventTarget obj
			var eventTarget = {};		// the actual events fire at this
			if(emitter.addEventListener){
				emitter.addEventListener( eventName, eventTarget );
			}else if(emitter.addListener){
				emitter.addListener( eventTarget );
			}else{
				// cannot create event,  so return nothing
				var nam = (emitter._name === undefined) ? "[object]" : '"'+emitter._name+'"';
				trace('ERROR:  '+nam+' cannot send events. ('+eventName+')');
				return null;
			}
			
			// event occurs => then()
			_interface.fire = eventTarget[eventName] = function(){
				_interface.then.apply( null, arguments.slice() );		// when this event occurs,  run then()  and pass-thru all provided parameters to it
				// tell()
				var params = [eventName].concat( arguments.slice() );
				sendEventToTarget.apply( null, params );		// when this event occurs,  pass the event to the tellEventTarget
				// once
				if(fireOnce)		_interface.disable();
			}// upon event()
			
			// remember this event
			var eventDetails = {
				emitter: emitter,
				eventName: eventName,
				eventTarget: eventTarget, 
				fire:  function() {
					return _interface.fire();
				}
			}
			eventEmitters.push(eventDetails);
			
			// manually destroy event
			_interface.disable = function(){
				delete _interface.fire;
				disableEvent( emitter, eventName, eventTarget );
				forgetEvent( emitter, eventName, eventTarget );
			}// disable()
			_interface.tell = event.tell;
			_interface.once = event.once;
			
			// output:  {}.then  {}.tell  {}.once
			return _interface;
		}// from()
		
		
		// output:  {}.then  {}.from()  {}.tell  {}.once
		return event;
	}// to()
	
	
	
	
	//////////////////////////////////////////
	// once
	react.once = function(){
		return reactOnce;		// make this a chain-able monad
	}// react.once()
	
	reactOnce.to = function( param ){
		return react.to( param, true );
	}// reactOnce.to()
	
	
	
	//////////////////////////////////////////
	function unload( fireUnloadEvents ){
		if( fireUnloadEvents === undefined )		fireUnloadEvents = true;		// true unless told otherwise
		for(var nam in eventEmitters){
			var details = eventEmitters[nam];
			var emitter = details.emitter;
			var eventName = details.eventName;
			var eventTarget = details.eventTarget;
			if( fireUnloadEvents  &&  eventName === "unload" )		details.fire();		// fire all "unload" events
			disableEvent( emitter, eventName, eventTarget );
		}// for:  each known event
		eventEmitters = [];
	}// unload()
	react.unload = once( unload );
	
	
	//////////////////////////////////////////
	if(defaultUnloadEmitter){
		react.to("unload").then = function( ){
			react.unload( false );
		} // upon unload event()
	}// if:  defaultUnloadEmitter is specified
	
	
	return react;
	
	
	//////////////////////////////////////////
	function disableEvent( emitter, eventName, eventTarget )
	{
		if(emitter.removeEventListener){
			emitter.removeEventListener( eventName, eventTarget );
		}else{
			emitter.removeListener( eventTarget );
		}
	}// disableEvent()
	
	
	function forgetEvent( emitter, eventName, eventTarget )
	{
		for(var e in eventEmitters){
			var thisEvent = eventEmitters[e];
			if(thisEvent.emitter			!== emitter)				continue;		// no match,  so don't remove
			if(thisEvent.eventName		!== eventName)			continue;		// no match,  so don't remove
			if(thisEvent.eventTarget	!== eventTarget)		continue;		// no match,  so don't remove
			// remove
			eventEmitters.splice( e, 1 );
		}// for:  each known event
		delete thisEvent;
	}// forgetEvent()
	
	
	function once( func ){
		var done = false;
		return function () {
			return done ? void 0 : ((done = true), func.apply(this, arguments));
		}
	}// once()
	
}// make_react()